Option Explicit
Dim compName, objWMI, colSecLog, objEvent, i
'
' This script uses WMI to extract events from the Security log where:
'  - The type is "Audit Failure" (5)
'  - The date is today
'  - The error code points to an incorrect password (0xC000006A)
'
compName = "localhost"
'
' Get the WMI interface
'
Set objWMI = GetObject("winmgmts:{(Security)}!\\" & _ 
                       compName & "\root\cimv2")
'
' Return all the events that meet our criteria
'
Set colSecLog = objWMI.ExecQuery("SELECT * FROM Win32_NTLogEvent Where " & _
                           "LogFile = 'Security' And " & _
                           "EventType = 5 And " & _ 
                           "TimeWritten > '" &  TodaysDate & "' And " & _ 
                           "Message Like '%0xC000006A%'")
'
' Run through the returned events
'
i = 0
For Each objEvent in colSecLog
    '
    ' Display the event data
    '
    WScript.Echo "Category: " & objEvent.CategoryString & VBCrLf & _
                 "Computer: " & objEvent.ComputerName & VBCrLf & _
                 "User: " & objEvent.User & VBCrLf & _
                 "Event Type: " & objEvent.Type & VBCrLf & _
                 "Event Code: " & objEvent.EventCode & VBCrLf & _
                 "Source Name: " & objEvent.SourceName & VBCrLf & _
                 "Time Written: " & ReturnLogDate(objEvent.TimeWritten) & _
                 VBCrLf & VBCrLf & _
                 "Message: " & VBCrLf & VBCrLf & objEvent.Message
    i = i + 1
Next
'
' Check for no events
'
If i = 0 Then
    WScript.Echo "No events found!"
End If
'
' Release objects
'
Set objWMI = Nothing
Set colSecLog = Nothing
'
' TodaysDate()
' This function creates a datatime string based on today's date
'
Function TodaysDate()
	  Dim strDay, strMOnth, strYear
    strYear = Year(Now)
    If Month(Now) < 10 Then
    	strMonth = "0" & Month(Now)
    Else
    	strMonth = Month(Now)
    End If
    If Day(Now) < 10 Then
    	strDay = "0" & Day(Now)
    Else
    	strDay = Day(Now)
    End If
    TodaysDate = strYear & strMonth & strDay & "000000.000000-000"
End Function
'
' ReturnLogDate()
' This function takes the event datetime value and converts
' it to a friendlier date and time format
'
Function ReturnLogDate(logTime)
    Dim eventDay, eventMonth, eventYear
    Dim eventSecond, eventMinute, eventHour
    eventYear = Left(logTime, 4)
    eventMonth = Mid(logTime, 5, 2)
    eventDay = Mid(logTime, 7, 2)
    eventHour = Mid(logTime, 9, 2)
    eventMinute = Mid(logTime, 11, 2)
    eventSecond = Mid(logTime, 13, 2)
    ReturnLogDate = DateSerial(eventYear, eventMonth, eventDay) & " " & _ 
                    TimeSerial(eventHour, eventMinute, eventSecond)
End Function