Option Explicit
Dim objFSO, objFolder, objFiles, objFile
Dim intMaxFolderSize, intFolderSize, intFileSize, intDeletedFiles, intDeletedFilesSize
Dim strFolder, strFileName, strOldestFileName
Dim dtFileDate, dtOldestFileDate
'
' Initialize some variables
'
' Set maximum folder size to 100MB (104,857,600 bytes)
' You can change this if you want
'
intMaxFolderSize = 104857600
'
' Change the following value to path of the folder you want to work with
'
strFolder = "C:\Users\Paul\QuickBooks\test"
strOldestFileName = ""
dtOldestFileDate = Now
intDeletedFiles = 0
intDeletedFilesSize = 0
'
' Initialize the file system object and get the folder
'
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objFolder = objFSO.GetFolder(strFolder)
'
' Get the size of the folder
'
intFolderSize = objFolder.Size
'
' Is it larger than our maximum size?
'
Do While intFolderSize > intMaxFolderSize
    '
    ' If so, return the files in the folder
    '
    Set objFiles = objFolder.Files
    '
    ' Run through the files
    '
    For Each objFile in objFiles
        '
        ' Get the file name, date, and size
        '
        strFileName = objFile.Path
        dtFileDate = objFile.DateCreated
        intFileSize = objFile.Size
        '
        ' Is it the oldest file in the folder so far?
        '
        If dtFileDate < dtOldestFileDate Then
            '
            ' If so, store its date as the oldest and save the file path
            '
            dtOldestFileDate = dtFileDate
            strOldestFileName = strFileName
        End If
    Next
    '
    ' Delete the oldest file
    '
    objFSO.DeleteFile(strOldestFileName)
    '
    ' Update the number of files and total size deleted
    '
    intDeletedFiles = intDeletedFiles + 1
    intDeletedFilesSize = intDeletedFilesSize + intFileSize
    '
    ' Reset some variables for the next loop
    '
    strOldestFileName = ""
    dtOldestFileDate = Now
    intFolderSize = objFolder.Size
Loop
'
' Display the number of files deleted and the approximate size of the deleted files
'
MsgBox "Deleted " & intDeletedFiles & " file(s) (approximately " & _ 
       Int(intDeletedFilesSize / 1024 / 1024) & "MB)"
