Option Explicit
Dim compName, objWMI, colOperatingSystems, objOS
'
' This script uses WMI to connect to a remote computer 
' and get the service pack version number
'
' Be sure to change "REMOTEPC" to the name of the remote computer
' that you want to work with.
'
compName = "REMOTEPC"
'
' Get the WMI interface
'
Set objWMI = GetObject("winmgmts:{(Security)}!\\" & _ 
                       compName & "\root\cimv2")
'
' Return the computer's installed operating systems
'
Set colOperatingSystems = objWMI.ExecQuery _
    ("Select * from Win32_OperatingSystem")
'
' Display the OS name and service pack version number
'
For Each objOS In colOperatingSystems
    WScript.Echo "Windows Service Pack Version on " & compName & ":" & _
        vbCrLf & vbCrLf & _
        objOS.Caption & vbCrLf & _
        "Service Pack " & _
        objOS.ServicePackMajorVersion & _
        "." & objOS.ServicePackMinorVersion
Next

