Option Explicit
Dim strComputer, objWMI, collDrivers, objDriver, intDrivers
Dim objFSO, strFolder, objFile
'
' Change the following value to the path of the folder 
' where you want to store the text file
'
strFolder = "d:\backups\"
'
' Initialize the file system object
'
Set objFSO = CreateObject("Scripting.FileSystemObject")
'
' Create the text file
'
Set objFile = objFSO.CreateTextFile(strFolder & "drivers.txt", True)
'
' Get the WMI object
'
strComputer = "."
Set objWMI = GetObject("winmgmts:\\" & strComputer)
'
' Return the collection of device drivers on the computer
'
Set collDrivers = objWMI.ExecQuery _
    ("Select * from Win32_PnPSignedDriver")
'
' Run through each item in the collection
'
intDrivers = 0
For Each objDriver in collDrivers
    '
    ' Write the driver data to the text file
    '
    objFile.WriteLine(objDriver.DeviceName)
    objFile.WriteLine("========================================")
    objFile.WriteLine("Device Class: " & objDriver.DeviceClass)
    objFile.WriteLine("Device Description: " & objDriver.Description)
    objFile.WriteLine("Device ID: " & objDriver.DeviceID)
    objFile.WriteLine("INF Filename: " & objDriver.InfName)
    objFile.WriteLine("Driver Provider: " & objDriver.DriverProviderName)
    objFile.WriteLine("Driver Version: " & objDriver.DriverVersion)
    objFile.WriteLine("Driver Date: " & ReturnDriverDate(objDriver.DriverDate))
    objFile.WriteLine("")
    intDrivers = intDrivers + 1
Next
'
' Close the text file
'
objFile.Close
WScript.Echo "Wrote " & intDrivers & " drivers to the text file."

'
' ReturnDriverDate()
' This function takes the driver datetime value and converts
' it to a friendlier date and time format
'
Function ReturnDriverDate(dDriverDate)
    Dim eventDay, eventMonth, eventYear
    Dim eventSecond, eventMinute, eventHour
    eventYear = Left(dDriverDate, 4)
    eventMonth = Mid(dDriverDate, 5, 2)
    eventDay = Mid(dDriverDate, 7, 2)
    eventHour = Mid(dDriverDate, 9, 2)
    eventMinute = Mid(dDriverDate, 11, 2)
    eventSecond = Mid(dDriverDate, 13, 2)
    ReturnDriverDate = DateSerial(eventYear, eventMonth, eventDay) & " " & _ 
                    TimeSerial(eventHour, eventMinute, eventSecond)
End Function