// This global array holds all items that are currently in the database
// Each item is a database_record object
var database_records = new Array()

// This global variable tracks the total number of items ordered
var total_ordered = 0

// This global variable holds the personal details about the user
var current_user

// These global variables set the names of your pages
var store_page = "30.1.htm"
var shopping_cart_page = "30.2.htm"
var personal_details_page = "30.3.htm"
var credit_card_page = "30.4.htm"

// These global variables set the tax rate and shipping charge per item
var tax_rate = 0.05
var shipping_charge = 5

// function database_record(description, number, price, quantity)
//
//     description    A description of the item.
//     number         A number that uniquely identifies the item.
//     price          The price of the item.
//     quantity       The quantity of the item that the user has ordered.
//
// This function creates a new database_record object.

function database_record(description, number, price, quantity) {
    this.description = description
    this.number = number
    this.price = price
    this.quantity = quantity
}

// function make_database()
//
// This function initializes the database_records array

function make_database() {

    // Create the default records
    var record_index = 0
    database_records[record_index] = 
        new database_record("The Complete Idiot\'s Guide to Windows Me", 
                            "0-7897-2407-3", 
                            19.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("The Unauthorized Guide to Windows Me", 
                            "0-7897-2452-9", 
                            24.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("The Complete Idiot\'s Guide to Windows 2000 Pro", 
                            "0-7897-2129-5", 
                            19.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("The Complete Idiot\'s Guide to Windows 98", 
                            "0-7897-1493-0", 
                            14.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("The Complete Idiot\'s Guide to MORE Windows 98", 
                            "0-7897-1739-5", 
                            16.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("The Complete Idiot\'s Guide to Creating a Web Page", 
                            "0-7897-2256-9", 
                            19.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("Paul McFedries\' Windows 98 Unleashed", 
                            "0-672-31224-7", 
                            54.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("Windows 98 Unleashed", 
                            "0-672-31235-2", 
                            34.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("VBA for Office 2000 Unleashed", 
                            "0-672-31567-X", 
                            39.99, 
                            0)
    record_index++
    database_records[record_index] = 
        new database_record("Office 97 Unleashed", 
                            "0-672-31144-5", 
                            49.99, 
                            0)

    // Load the orders from the cookie
    load_orders()
    
}

// function load_orders()
//
// This function reads the order quantities from the order
// cookie and loads them into the database_records array.

function load_orders() {

    // Get the orders cookie
    var orders_cookie = get_cookie("orders")

    // If the cookie doesn't exist, return
    if (!orders_cookie) {return}

    // Split all the orders into an array
    var user_orders = orders_cookie.split("+")

    // Run through the orders
    for (var counter = 0; counter < user_orders.length; counter++) {
    
        // Store the quantity
        var order_quantity = user_orders[counter]
        
        // Update the database
        database_records[counter].quantity = order_quantity

        // Update the number of items that are in the shopping cart
        if (order_quantity > 0) {
            total_ordered++
        }
    }
}

// function save_orders()
//
// This function saves the orders in the database_records 
// array to a cookie named "orders".

function save_orders() {

    // This variable holds the string that's saved to the cookie
    var order_string = ""
    
    // Store the total number of records in the database
    var total_records = database_records.length
    
    // Run through the database array
    for (var counter = 0; counter < total_records; counter++) {

        // Add the quantity to the cookie string
        order_string += database_records[counter].quantity

        // If this isn't the last item, add the order delimiter (+)
        if (counter < total_records - 1) {
            order_string += "+"
        }
    }
    
    // Save the orders to a per-session cookie
    set_cookie("orders", order_string)
}



// function user_data(Salutation, First_Name, Last_Name, Email_Address, Company_Name, Address_1, Address_2, City, State, Postal_Code, Country)
//
//     Salutation       The salutation ("Dr.", "Miss", and so on)
//     First_Name       The user's first name
//     Last_Name        The user's last name
//     Email_Address    The user's email address
//     Company_Name     (Optional) The user's company name
//     Address_1        The user's street address
//     Address_2        (Optional) The second part of the user's street address
//     City             The user's city
//     State            The user's state or province
//     Postal_Code      The user's ZIP or postal code
//     Country          The user's country
//
// This function creates a new user_data object

function user_data(Salutation, First_Name, Last_Name, Email_Address, Company_Name, Address_1, Address_2, City, State, Postal_Code, Country) {
    this.Salutation = Salutation
    this.First_Name = First_Name
    this.Last_Name = Last_Name
    this.Email_Address = Email_Address
    this.Company_Name = Company_Name
    this.Address_1 = Address_1
    this.Address_2 = Address_2
    this.City = City
    this.State = State
    this.Postal_Code = Postal_Code
    this.Country = Country
}

// function save_personal_details(current_form)
//
//     current_form    A reference to the Form object that
//                     contains the user's personal details.
//
// This function saves the data in current_form 
// to a cookie named "personal_details".
// The cookie is a collection of pseudo-cookies:
//     - Each pseudo-cookie is separated with a colon (:)
//     - Each pseudo-cookie name and value is separated by a plus sign (+)

function save_personal_details(current_form) {

    // This variable holds the string that's saved to the cookie
    var cookie_string = ""
    
    // Run through the form
    for (var counter = 0; counter < current_form.length; counter++) {

        // Is the field a Text object?
        if (current_form[counter].type == "text") {
        
            // If so, add the field name and value to the pseudo-cookie
            cookie_string += current_form[counter].name + ":" +
                             escape(current_form[counter].value) + "&"
        
    }
        // Is the field a Select (single) object?
        else if (current_form[counter].type == "select-one") {
        
            // If so, add the field name and the text 
            // of the selected option to the pseudo-cookie
            var selected_option = current_form[counter].options[current_form[counter].selectedIndex].text
            cookie_string += current_form[counter].name + ":" +
                             escape(selected_option) + "&"
        }
    }
    
    // Remove the last delimiter
    cookie_string = cookie_string.substring(0, cookie_string.length - 1)

    // Save the personal_details to a temporary cookie
    set_cookie("personal_details", cookie_string)
}

// function load_personal_details()
//
// This function reads the personal_details cookie and 
// loads the data into the global current_user array. 

function load_personal_details() {
    
    // Create a new, empty, user_data object
    current_user = new user_data("", "", "", "", "", "", "", "", "", "", "")

    // Get the personal_details cookie
    var user_cookie = get_cookie("personal_details")

    // If it didn't exist, return
    if (!user_cookie) {
        return
    }

    // Split the cookie into an array of pseudo-cookies
    var pseudo_cookies = user_cookie.split("&")
    
    // Run through the pseudo-cookies
    for (var counter = 0; counter < pseudo_cookies.length; counter++) {

        // Split the pseudo-cookie into a name:value pair
        var pseudo_cookie_pair = pseudo_cookies[counter].split(":")
        
        // Store the array items
        var property_name = pseudo_cookie_pair[0]
        var property_value = pseudo_cookie_pair[1]
        
        // Update the corresponding user_data object property
        current_user[property_name] = unescape(property_value)
    }
}

function display_database() {
    
    var alert_string = ""
    for (var counter = 0; counter < database_records.length; counter++) {
        alert_string += database_records[counter].description + "\n"
        alert_string += database_records[counter].number + "\n"
        alert_string += database_records[counter].quantity + "\n"
        alert_string += database_records[counter].price + "\n\n"
    }
    alert(alert_string)
}