// function add_to_cart(item_number)
//
//     item_number         A string containsing the number that uniquely identifies the item.
//
// This function adds an item to the user's shopping cart.

function add_to_cart(item_number) {

    // Loop through the database_records array
    for (var counter = 0; counter < database_records.length; counter++) {
  
        // Is this the item number that's being ordered?
        if (database_records[counter].number == item_number) {

            // If yes, get the item's current order quantity
            var current_quantity = database_records[counter].quantity
            
            // Is the item not in the shopping cart?
            if (current_quantity == 0) {
                
                // If not, set the quantity to 1 to add the item to the cart
                update_record_quantity(counter, 1)
            }

            // Exit the loop
            break
        }
    }

    // Save the orders to the cookie
    save_orders()

    // Take the user to the shopping cart page
    location = shopping_cart_page
}

// function update_item_quantity(record_index, record_quantity)
//
//     record_index       The record's index within the database_records array.
//     record_quantity    The quantity ordered.
//
// This function updates a record's order quantity to record_quantity.

function update_record_quantity(record_index, record_quantity) {

    // Update the quantity
    database_records[record_index].quantity = record_quantity

    // Is the new quantity 0?
    if (record_quantity == 0) {
                
        // If so, decrement the total number of items ordered
        // Note: This removes the item from the shopping cart
        total_ordered--
    }
}

// function recalculate_order()
//
// This function recalculates the shopping cart totals.

function recalculate_order() {

    // Loop through the fields in the shopping cart form
    for (var counter = 0; counter < document.shopping_cart.length; counter++) {
        
        // Only work with the "Quantity" text fields
        if (document.shopping_cart[counter].type == "text") {
            
            // Is the value empty or negative?
            current_quantity = document.shopping_cart[counter].value
            if (its_empty(current_quantity) || parseInt(current_quantity) < 0) {
                
                // If so, warn the user, set the focus(), and return
                alert("Please enter a quantity greater than or equal to 0.")
                document.shopping_cart[counter].focus()
                return
            }
            
            // Is the value a floating-point number?
            if (its_floating_point(current_quantity)) {
                
                // If so, warn the user and return
                alert("Please enter an integer quantity.")
                document.shopping_cart[counter].focus()
                return
            }
            
            // Otherwise, the quantity is valid, so update it
            var current_index = document.shopping_cart[counter].record_index
            update_record_quantity(current_index, current_quantity)
        }
    }

    // Save the updated orders to the cookie
    save_orders()
            
    // Reload the page
    location.reload()
}

// function remove_from_cart(record_index)
//
//     record_index    The record's index within the database_records array.
//
// This function removes the item specified by record_index.

function remove_from_cart(record_index) {

    // Set the item's quantity to 0
    update_record_quantity(record_index, 0)

    // Save the updated database to the cookie
    save_orders()

    // Reload the page
    location.reload()
}

// function empty_cart()
//
// This function deletes everything in the shopping
// cart by deleting the shopping_cart cookie.

function empty_cart() {
    
    // Loop through the database_records array
    for (var counter = 0; counter < database_records.length; counter++) {
  
        // If so, set the item's quantity to 0
        update_record_quantity(counter, 0)
    }

    // Save the updated database to the cookie
    save_orders()

    // Reload the page
    location.reload()
}



// function round_decimals(original_number, decimals)
//
//     original_number    A floating-point number.
//     decimals           The number of decimal places.
//
// Returns: the original_number rounded to decimals decimal places.

function round_decimals(original_number, decimals) {
    var result1 = original_number * Math.pow(10, decimals)
    var result2 = Math.round(result1)
    var result3 = result2 / Math.pow(10, decimals)
    return pad_with_zeros(result3, decimals)
}

// function pad_with_zeros(rounded_value, decimal_places)
//
//     rounded_value    A rounded floating-point number.
//     decimals         The number of decimal places.
//
// Returns: the rounded_number padded with extra zeros 
// to get the specified number of decimal places.

function pad_with_zeros(rounded_value, decimal_places) {

    // Convert the number to a string
    var value_string = rounded_value.toString()
    
    // Locate the decimal point
    var decimal_location = value_string.indexOf(".")

    // Is there a decimal point?
    if (decimal_location == -1) {
        
        // If no, then all decimal places will be padded with 0s
        decimal_part_length = 0
        
        // If decimal_places is greater than zero, tack on a decimal point
        value_string += decimal_places > 0 ? "." : ""
    }
    else {

        // If yes, then only the extra decimal places will be padded with 0s
        decimal_part_length = value_string.length - decimal_location - 1
    }
    
    // Calculate the number of decimal places that need to be padded with 0s
    var pad_total = decimal_places - decimal_part_length
    
    if (pad_total > 0) {
        
        // Pad the string with 0s
        for (var counter = 1; counter <= pad_total; counter++) 
            value_string += "0"
        }
    return value_string
}

