// This array holds all of the document's DHTML-able objects
var dhtml_objects = new Array()

// This function creates the custom objects that serve as cross-browser front-ends
function create_object_array() {

    // All the <div> and <span> tags are stored in these variables
    var div_tags
    var span_tags
    var css_tags

    // Is the browser W3C DOM compliant?
    if (document.getElementById) {
    
        // If so, use getElementsByTagName() to get the <div> tags
        div_tags = document.getElementsByTagName("div")

        // Loop through the <div> tags
        for (var counter = 0; counter < div_tags.length; counter++) {

            // Store the current object
            current_object = div_tags[counter]
            
            // Store how the browser accesses styles
            object_css = current_object.style
            
            // Store the object's id
            object_id = current_object.id
            
            // Only store those tags that have an id
            if (object_id) {
            
                // Create a new dhtml_object and store it in dhtml_objects
                dhtml_objects[object_id] = new dhtml_object(current_object,
                                                            object_css, 
                                                            object_id)
            }
        }
        
        // Use getElementsByTagName() to get the <span> tags
        span_tags = document.getElementsByTagName("span")
        
        // Loop through the <span> tags
        for (var counter = 0; counter < span_tags.length; counter++) {
            
            // Store the current object
            current_object = span_tags[counter]
            
            // Store how the browser accesses styles
            object_css = current_object.style
            
            // Store the object's id
            object_id = current_object.id
            
            // Only store those tags that have an id
            if (object_id) {
            
                // Create a new dhtml_object and store it in dhtml_objects
                dhtml_objects[object_id] = new dhtml_object(current_object,
                                                            object_css, 
                                                            object_id)
            }
        }
    }
    
    // Is the browser DHTML DOM compliant?
    else if (document.all) {
        
        // If so, use document.all to get the <div> tags
        div_tags = document.all.tags("div")
        
        // Loop through the <div> tags
        for (var counter = 0; counter < div_tags.length; counter++) {
        
            // Store the current object
            current_object = div_tags[counter]
            
            // Store how the browser accesses styles
            object_css = current_object.style
            
            // Store the object's id
            object_id = current_object.id
            
            // Only store those tags that have an id
            if (object_id) {
            
                // Create a new dhtml_object and store it in dhtml_objects
                dhtml_objects[object_id] = new dhtml_object(current_object,
                                                            object_css, 
                                                            object_id)
            }
        }

        // Use document.all to get the <span> tags
        span_tags = document.all.tags("span")
        
        // Loop through the <span> tags
        for (var counter = 0; counter < span_tags.length; counter++) {
        
            // Store the current object
            current_object = span_tags[counter]
            
            // Store how the browser accesses styles
            object_css = current_object.style
            
            // Store the object's id
            object_id = current_object.id
            
            // Only store those tags that have an id
            if (object_id) {
            
                // Create a new dhtml_object and store it in dhtml_objects
                dhtml_objects[object_id] = new dhtml_object(current_object,
                                                            object_css, 
                                                            object_id)
            }
        }
    }
    
    // Is the browser LDOM compliant?
    else if (document.layers) {
    
        // Use document.layers to get the positioned <div> and <span> tags
        css_tags = document.layers

        // Loop through the layers
        for (var counter = 0; counter < css_tags.length; counter++) {
            
            // Store the current object
            current_object = css_tags[counter]
            
            // Store how the browser accesses styles
            object_css = current_object
            
            // Store the object's id
            object_id = current_object.id
            
            // Only store those tags that have an id
            if (object_id) {
            
                // Create a new dhtml_object and store it in dhtml_objects
                dhtml_objects[object_id] = new dhtml_object(current_object,
                                                            object_css, 
                                                            object_id)
            }
        }
    }
}

function dhtml_object (obj, css, id) {
    this.obj = obj
    this.css = css
    this.id = id
    this.left = get_left
    this.right = get_right
    this.top = get_top
    this.bottom = get_bottom
    this.width = get_width
    this.height = get_height
    this.visibility = get_visibility
    this.zIndex = get_zIndex
    this.move_to = move_to
    this.move_by = move_by
    this.set_left = set_left
    this.set_top = set_top
    this.set_width = set_width
    this.set_height = set_height
    this.set_visibility = set_visibility
    this.set_zIndex = set_zIndex
    this.move_above = move_above
    this.move_below = move_below
    this.set_backgroundColor = set_backgroundColor
    this.set_backgroundImage = set_backgroundImage
    this.set_html = set_html
    this.get_clip_top = get_clip_top
    this.get_clip_right = get_clip_right
    this.get_clip_bottom = get_clip_bottom
    this.get_clip_left = get_clip_left
    this.get_clip_width = get_clip_width
    this.get_clip_height = get_clip_height
    this.resize_clip_to = resize_clip_to
    this.resize_clip_by = resize_clip_by
}

function get_left() {
    return parseInt(this.css.left)
}

function get_right() {
    return this.left() + this.width()
}

function get_top() {
    return parseInt(this.css.top)
}

function get_bottom() {
    return this.top() + this.height()
}

function get_width() {
    
    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
        
        // If so, is the width defined?
        if (this.css.width) {
           
            // If so, return the width property
            return parseInt(this.css.width)
        }
        else {
               
            // If not, return the offsetWidth property
           return parseInt(this.obj.offsetWidth)
       }
    }
    else {
    
        // If not, return the layer's document width
        return parseInt(this.obj.document.width)
    }
}

function get_height() {
    
    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
        
        // If so, is the height defined?
        if (this.css.height) {
           
            // If so, return the height property
            return parseInt(this.css.height)
        }
        else {
               
            // If not, return the offsetHeight property
           return parseInt(this.obj.offsetHeight)
       }
    }
    else {
    
        // If not, return the layer's document height
        return parseInt(this.obj.document.height)
    }
}

function get_visibility() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {

        // If so, is the visibility defined?
        if (this.css.visibility) {
        
            // If so, return the visibility property
            return this.css.visibility
        }
    }
    else {
    
        // Otherwise, it's an LDOM browser, so
        // handle the proprietary visibility values
        if (this.css.visibility == "show") {
            return "visible"
        }
        if (this.css.visibility == "hide") {
            return "hidden"
        }
    }

    // If we get this far, just return "inherit"
    return "inherit"
}

function get_zIndex() {
    return this.css.zIndex
}

function move_to (new_left, new_top) {
    this.css.left = new_left
    this.css.top = new_top
}

function move_by (delta_left, delta_top) {

    // Add the delta values
    this.css.left = this.left() + parseInt(delta_left)
    this.css.top = this.top() + parseInt(delta_top)
}

function set_left (new_left) {
    this.css.left = new_left
}

function set_top (new_top) {
    this.css.top = new_top
}

function set_width (new_width) {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, just set the width property
        this.css.width = new_width
    }
}

function set_height (new_height) {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, just set the width property
        this.css.height = new_height
    }
}

function set_visibility (new_visibility) {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, just set the visibility
        // to the value of the argument
        this.css.visibility = new_visibility
    }
    else {
        
        // Otherwise, set the proprietary visibility values
        if (new_visibility == "visible") {
            this.css.visibility = "show"
        }
        else if (new_visibility == "hidden") {
            this.css.visibility = "hide"
        }
        else {
            this.css.visibility = "inherit"
        }
    }
}

function set_zIndex(new_zindex) {
    
    // Is the new z-index greater than 0?
    if (new_zindex > 0) {
    
        // If so, set it
        this.css.zIndex = new_zindex
    }
    else {
    
        // If not, set it to 0
        this.css.zIndex = 0
    }
}

function move_above(reference_object) {
    this.css.zIndex = reference_object.css.zIndex + 1
}

function move_below(reference_object) {
    
    // Get the z-index of the reference object
    reference_zindex = reference_object.css.zIndex
    
    // Is it greater than 0?
    if (reference_zindex > 0) {
    
        // If so, set this object's zindex to one less
        this.css.zIndex =  reference_zindex - 1
    }
    else {
    
        // If not, set the reference object's z-index to 1
        // and this object's z-index to 0
        reference_object.css.zIndex = 1
        this.css.zIndex = 0
    }
}

function set_backgroundColor(new_color) {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, use the backgroundColor property
        this.css.backgroundColor = new_color
    }
    else {
    
        // If not, use the bgcolor property
        this.css.bgColor = new_color
    }
}

function set_backgroundImage(new_image) {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, use the backgroundImage property
        this.css.backgroundImage = "url(" + new_image + ")"
    }
    else {
    
        // If not, use the background property
        this.css.background.src = new_image
    }
}

function set_html(new_html) {

   // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, use the innerHTML property
        this.obj.innerHTML = new_html
    }
    else {
    
        // If not, use the document.write() method
        this.obj.document.open()
        this.obj.document.write(new_html)
        this.obj.document.close()
    }
}

function get_clip_top() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.top
    }
    else {
        
        // Otherwise, use clip.top
        return this.css.clip.top
    }
}

var current_clip

function clip_object(top, right, bottom, left) {
    this.top = top
    this.right = right
    this.bottom = bottom
    this.left = left
}

function parse_dom_clip(current_object) {

    clip_string = current_object.css.clip
    
    if (clip_string.length > 0) {
        var values_string = clip_string.slice(5, clip_string.length - 1)
        var clip_values = values_string.split(" ")
        var clip_top = parseInt(clip_values[0])
        var clip_right = parseInt(clip_values[1])
        var clip_bottom = parseInt(clip_values[2])
        var clip_left = parseInt(clip_values[3])
    }
    else {
        var clip_top = 0
        var clip_right = current_object.width()
        var clip_bottom = current_object.height()
        var clip_left = 0
    }
    current_clip = new clip_object(clip_top, clip_right, clip_bottom, clip_left)
}

function get_clip_right() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.right
    }
    else {
        
        // Otherwise, use clip.right
        return this.css.clip.right
    }
}

function get_clip_bottom() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.bottom
    }
    else {
        
        // Otherwise, use clip.bottom
        return this.css.clip.bottom
    }
}

function get_clip_left() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.left
    }
    else {
        
        // Otherwise, use clip.left
        return this.css.clip.left
    }
}

function get_clip_width() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.right - current_clip.left
    }
    else {
        
        // Otherwise, use clip.width
        return this.css.clip.width
    }
}

function get_clip_height() {

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // If so, first parse the clip string
        parse_dom_clip(this)
        
        // Clip values are now in the current_clip object
        return current_clip.bottom - current_clip.top
    }
    else {
        
        // Otherwise, use clip.width
        return this.css.clip.height
    }
}

function resize_clip_to(new_top, new_right, new_bottom, new_left) {

    if (new_top == "auto") {new_top = this.get_clip_top() }
    if (new_right == "auto") {new_right = this.get_clip_right() }
    if (new_bottom == "auto") {new_bottom = this.get_clip_bottom() }
    if (new_left == "auto") {new_left = this.get_clip_left() }

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // Clip values are now in the current_clip object
        this.css.clip = "rect(" + new_top + " " + new_right + " " + 
                                  new_bottom + " " + new_left + ")"
    }
    else {
        
        // Otherwise, use clip properties
        this.css.clip.top = new_top
        this.css.clip.right = new_right
        this.css.clip.bottom = new_bottom
        this.css.clip.left = new_left
    }
}

function resize_clip_by(delta_top, delta_right, delta_bottom, delta_left) {

    var new_top = this.get_clip_top() + delta_top
    var new_right = this.get_clip_right() + delta_right
    var new_bottom = this.get_clip_bottom() + delta_bottom
    var new_left = this.get_clip_left() + delta_left

    // Is this a W3C or DHTML DOM browser?
    if (!document.layers) {
    
        // Clip values are now in the current_clip object
        this.css.clip = "rect(" + new_top + " " + new_right + " " + 
                                  new_bottom + " " + new_left + ")"
    }
    else {
        
        // Otherwise, use clip properties
        this.css.clip.top = new_top
        this.css.clip.right = new_right
        this.css.clip.bottom = new_bottom
        this.css.clip.left = new_left
    }
}

function get_mouse_x(current_event) {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the event.clientX property
        return event.clientX
    }
    // Is this Netscape Explorer 4 or later?
    else if (its_ns4plus) {
        
        // Otherwise, return the pageX property
        return current_event.pageX
    }
    else {
        
        // Otherwise, return null
        return null
    }
}

function get_mouse_y(current_event) {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the event.clientY property
        return event.clientY
    }
    // Is this Netscape Explorer 4 or later?
    else if (its_ns4plus) {
        
        // If so, return the pageY property
        return current_event.pageY
    }
    else {
        
        // Otherwise, return null
        return null
    }
}

function get_client_width() {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the clientWidth property
        return document.body.clientWidth
    }
    else if (its_ns4plus) {
        
        // If so, return the innerWidth property
        return window.innerWidth - 18
    }
    else {
        
        // Otherwise, return null
        return null
    }
}

function get_client_height() {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the clientHeight property
        return document.body.clientHeight
    }
    // Is this Netscape Explorer 4 or later?
    else if (its_ns4plus) {
        
        // If so, return the innerHeight property
        return window.innerHeight - 18
    }
    else {
        
        // Otherwise, return null
        return null
    }
}

function get_client_scroll_left() {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the scrollLeft property
        return document.body.scrollLeft
    }
    // Is this Netscape Explorer 4 or later?
    else if (its_ns4plus) {
        
        // If so, return the pageXOffset property
        return pageXOffset
    }
    else {
        
        // Otherwise, return null
        return null
    }
}

function get_client_scroll_top() {
    
    // Is this Internet Explorer 4 or later?
    if (its_ie4plus) {
        
        // If so, return the scrollTop property
        return document.body.scrollTop
    }
    // Is this Netscape Explorer 4 or later?
    else if (its_ns4plus) {
        
        // If so, return the pageYOffset property
        return pageYOffset
    }
    else {
        
        // Otherwise, return null
        return null
    }
}
