'Listing 12.1. A VBScript example that displays the status and free space for your system's drives.
'
Option Explicit
Dim objFSO, colDiskDrives, objDiskDrive, strMessage

' Create the File System Object
Set objFSO = CreateObject("Scripting.FileSystemObject")

' Get the collection of disk drives
Set colDiskDrives = objFSO.Drives

' Run through the collection
strMessage = "Disk Drive Status Report" & vbCrLf & vbCrLf
For Each objDiskDrive in colDiskDrives

    ' Add the drive letter to the message
    strMessage = strMessage & "Drive: " & objDiskDrive.DriveLetter & vbCrLf

    ' Check the drive status
    If objDiskDrive.IsReady = True Then

        ' If it's ready, add the status and the free space to the message
        strMessage = strMessage & "Status: Ready" & vbCrLf
        strMessage = strMessage & "Free space: " & objDiskDrive.FreeSpace
        strMessage = strMessage & vbCrLf & vbCrLf
    Else

        ' Otherwise, just add the status to the message
        strMessage = strMessage & "Status: Not Ready" & vbCrLf & vbCrLf
    End If
Next

' Display the message
Wscript.Echo strMessage
